<?php
// Database Configuration
$host = 'localhost';
$dbname = 'shafpknj_arabstrg';
$username = 'shafpknj_ahmed';
$password = '2719243214kK';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// ==================================================
// ============= API LOGIC (Self-Contained) =============
// ==================================================
if (isset($_GET['action'])) {
    header('Content-Type: application/json');
    $action = $_GET['action'];

    try {
        // --- ACTION 1: Get all Seasons and all Sessions ---
        if ($action === 'getInitialData') {
            $seasons_stmt = $pdo->query("SELECT season_id, season_name FROM seasons WHERE is_active = 1 ORDER BY start_date DESC");
            $seasons = $seasons_stmt->fetchAll(PDO::FETCH_ASSOC);

            $sessions_stmt = $pdo->query("SELECT session_id, season_id, session_name, session_date FROM sessions ORDER BY session_date DESC");
            $sessions = $sessions_stmt->fetchAll(PDO::FETCH_ASSOC);

            echo json_encode(['success' => true, 'seasons' => $seasons, 'sessions' => $sessions]);
            exit;
        }

        // --- ACTION 2: Get stats for a specific session ---
        if ($action === 'getStatsForSession' && isset($_GET['session_id'])) {
            $session_id = filter_var($_GET['session_id'], FILTER_VALIDATE_INT);
            if (!$session_id) {
                throw new Exception("Invalid session ID.");
            }

            $stmt = $pdo->prepare("SELECT * FROM session_country_stats WHERE session_id = ?");
            $stmt->execute([$session_id]);
            $stats = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Manually add 'code' field from 'country_tag'
            foreach ($stats as $key => $stat) {
                $stats[$key]['code'] = $stat['country_tag'];
            }
            
            echo json_encode($stats); // Return the raw array
            exit;
        }

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => $e->getMessage()]);
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إحصائيات السيرفر</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        body { font-family: 'Tajawal', sans-serif; background-color: #111827; color: #f3f4f6; }
        .logo { width: 120px; height: 120px; border-radius: 50%; box-shadow: 0 0 30px rgba(59, 130, 246, 0.6); border: 2px solid rgba(59, 130, 246, 0.8); }
        .container { max-width: 1400px; margin: 0 auto; padding: 0 1rem 2rem 1rem; }
        .card { background-color: #1f2937; border-radius: 12px; box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.2), 0 4px 6px -2px rgba(0, 0, 0, 0.1); }
        .glass { background-color: rgba(31, 41, 55, 0.8); backdrop-filter: blur(10px); border: 1px solid rgba(255, 255, 255, 0.1); }
        .form-select {
            background-color: #374151; border: 1px solid #4b5563; color: #fff;
            border-radius: 8px; padding: 0.75rem; font-size: 1rem;
            background-image: url('data:image/svg+xml;charset=utf-8,<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path stroke="%239ca3af" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="m6 8 4 4 4-4"/></svg>');
            background-repeat: no-repeat;
            background-position: left 0.75rem center;
            background-size: 1.25em 1.25em;
            -webkit-appearance: none; -moz-appearance: none; appearance: none;
            padding-right: 2.5rem;
        }
        .form-select:disabled { opacity: 0.5; cursor: not-allowed; }
        .btn-primary {
            background-color: #2563eb; color: #fff; font-weight: 700; border-radius: 8px;
            padding: 0.75rem 1.5rem; transition: all 0.3s; cursor: pointer; border: none;
            display: flex; justify-content: center; align-items: center; height: 100%;
        }
        .btn-primary:hover:not(:disabled) { background-color: #1d4ed8; transform: translateY(-2px); }
        .btn-primary:disabled { background-color: #374151; cursor: not-allowed; transform: none; }
        
        /* --- CSS CHANGES HERE --- */
        .control-panel {
            display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem; /* Reduced gap */
            background: var(--card-bg); 
            padding: 1rem; /* Reduced padding */
            border-radius: 12px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.2); 
            margin-bottom: 20px; 
            border: 1px solid var(--border);
        }
        .control-group { 
            display: flex; 
            flex-direction: column; 
            gap: 0.75rem; /* Reduced gap */
        }
        
        .charts-grid {
            display: grid;
            grid-template-columns: repeat(1, minmax(0, 1fr));
            gap: 2rem; /* Increased gap */
        }
        @media (min-width: 1024px) {
            .charts-grid {
                grid-template-columns: repeat(4, minmax(0, 1fr)); /* 4 columns */
            }
        }
        .chart-card {
            padding: 1.5rem; transition: transform 0.3s, box-shadow 0.3s; cursor: pointer;
            opacity: 0; animation: fadeInUp 0.5s ease-out forwards;
        }
        .chart-card:hover { transform: translateY(-5px); box-shadow: 0 0 25px rgba(59, 130, 246, 0.3); }
        .chart-container {
            height: 280px; /* Reduced height */
            position: relative;
        }
        /* --- END OF CSS CHANGES --- */

        footer { text-align: center; padding: 2rem 1rem; color: #9ca3af; border-top: 1px solid #374151; margin-top: 2rem; }
        .loader-container { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(17, 24, 39, 0.9); display: flex; justify-content: center; align-items: center; z-index: 9999; backdrop-filter: blur(4px); }
        .loader-container.hidden { display: none; }
        .loader { border: 5px solid #374151; border-top: 5px solid #3b82f6; border-radius: 50%; width: 50px; height: 50px; animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
        .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0, 0, 0, 0.8); backdrop-filter: blur(5px); }
        .modal-content { background-color: #1f2937; margin: 5% auto; border-radius: 12px; width: 90%; max-width: 1200px; box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04); }
        .modal-header { padding: 1rem 1.5rem; border-bottom: 1px solid #374151; display: flex; justify-content: space-between; align-items: center; }
        .modal-title { font-size: 1.5rem; font-weight: 700; color: #fff; }
        .close-btn { color: #9ca3af; font-size: 2rem; font-weight: bold; background: none; border: none; cursor: pointer; transition: color 0.3s; }
        .close-btn:hover { color: #fff; }
        .modal-chart-container { padding: 1.5rem; height: 70vh; }
        <?php for ($i = 0; $i < 12; $i++): ?>
        .charts-grid .chart-card:nth-child(<?php echo $i + 1; ?>) { animation-delay: <?php echo $i * 0.05; ?>s; }
        <?php endfor; ?>
        @keyframes fadeInUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body class="bg-gray-900">
  
    <header class="py-12 mt-8">
        <div class="container px-4">
            <div class="flex flex-col items-center gap-4">
                <img src="logo.png" alt="شعار اللعبة" class="logo">
                <h1 class="text-3xl md:text-4xl font-bold text-white text-center">إحصائيات - رول بلاي العصر الحديث</h1>
            </div>
            <p class="text-center text-lg text-gray-400 mt-2"> <i class="fas fa-chart-bar"></i> أداة لعرض ومقارنة إحصائيات الجلسات</p>
        </div>
    </header>

  <div class="container">
    <section class="mb-8 fade-in-up">
      <div class="control-panel card glass">
        <h2 class="text-xl font-bold text-white mb-4 md:col-span-4">أدوات المقارنة</h2>
        
        <div class="control-group md:col-span-4">
            <label for="seasonSelector" class="form-label text-gray-300 mb-1 block font-medium"><i class="fas fa-calendar-alt mr-1"></i> الخطوة 1: اختر الموسم</label>
            <select id="seasonSelector" class="form-select w-full">
                <option value="">جار التحميل...</option>
            </select>
        </div>

        <div class="control-group md:col-span-2">
            <label for="session1Selector" class="form-label text-gray-300 mb-1 block font-medium">الخطوة 2: الجلسة الأولى</label>
            <select id="session1Selector" class="form-select w-full" disabled>
                <option value="">اختر موسماً أولاً</option>
            </select>
        </div>

        <div class="control-group md:col-span-2">
            <label for="session2Selector" class="form-label text-gray-300 mb-1 block font-medium">الخطوة 3: الجلسة الثانية (للمقارنة)</label>
            <select id="session2Selector" class="form-select w-full" disabled>
                <option value="">اختر موسماً أولاً</option>
            </select>
        </div>

        <div class="control-group md:col-span-2">
            <label for="viewType" class="form-label text-gray-300 mb-1 block font-medium">الخطوة 4: نوع العرض</label>
            <select id="viewType" class="form-select w-full">
                <option value="value">القيمة الفعلية</option>
                <option value="difference">الفرق بين الجلستين</option>
                <option value="percentage">النسبة المئوية للتغيير</option>
            </select>
        </div>

        <div class="control-group flex items-end md:col-span-2">
            <button id="compareButton" onclick="compareSessions()" class="btn-primary w-full text-lg" disabled>
                <i class="fas fa-sync-alt mr-2"></i> تحديث الرسوم
            </button>
        </div>
      </div>
    </section>

    <section class="charts-grid" id="chartsGrid">
      <div class="chart-card card" data-chart-type="gdp_total">
        <div class="chart-header"><h3 class="chart-title">الناتج المحلي الإجمالي</h3><p class="chart-subtitle" id="gdpSubtitle">القيمة الفعلية (بليون $)</p></div>
        <div class="chart-container"><canvas id="gdpGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="factories.civilian">
        <div class="chart-header"><h3 class="chart-title">المصانع المدنية</h3><p class="chart-subtitle" id="civilianSubtitle">العدد الفعلي</p></div>
        <div class="chart-container"><canvas id="civilianFactoriesGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="factories.military">
        <div class="chart-header"><h3 class="chart-title">المصانع العسكرية</h3><p class="chart-subtitle" id="militarySubtitle">العدد الفعلي</p></div>
        <div class="chart-container"><canvas id="militaryFactoriesGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="factories.naval">
        <div class="chart-header"><h3 class="chart-title">المصانع البحرية</h3><p class="chart-subtitle" id="navalSubtitle">العدد الفعلي</p></div>
        <div class="chart-container"><canvas id="navalFactoriesGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="defence_gain">
        <div class="chart-header"><h3 class="chart-title">إجمالي الإنفاق الدفاعي</h3><p class="chart-subtitle" id="defenseSubtitle">القيمة الفعلية (بليون $)</p></div>
        <div class="chart-container"><canvas id="totalDefenseGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="debt">
        <div class="chart-header"><h3 class="chart-title">الدين</h3><p class="chart-subtitle" id="debtSubtitle">القيمة الفعلية (بليون $)</p></div>
        <div class="chart-container"><canvas id="debtGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="gdp_per_capita">
        <div class="chart-header"><h3 class="chart-title">الناتج المحلي الإجمالي للفرد</h3><p class="chart-subtitle" id="gdpCapitaSubtitle">القيمة الفعلية ($)</p></div>
        <div class="chart-container"><canvas id="gdpPerCapitaGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="overall_productivity">
        <div class="chart-header"><h3 class="chart-title">الإنتاجية الكلية</h3><p class="chart-subtitle" id="productivitySubtitle">القيمة الفعلية</p></div>
        <div class="chart-container"><canvas id="overallProductivityGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="defence_breakdown_land">
        <div class="chart-header"><h3 class="chart-title">تكاليف القوات البرية</h3><p class="chart-subtitle" id="landDefenseSubtitle">القيمة الفعلية (بليون $)</p></div>
        <div class="chart-container"><canvas id="landDefenseGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="defence_breakdown_airforce">
        <div class="chart-header"><h3 class="chart-title">تكاليف القوات الجوية</h3><p class="chart-subtitle" id="airDefenseSubtitle">القيمة الفعلية (بليون $)</p></div>
        <div class="chart-container"><canvas id="airDefenseGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
      <div class="chart-card card" data-chart-type="defence_breakdown_navy">
        <div class="chart-header"><h3 class="chart-title">تكاليف القوات البحرية</h3><p class="chart-subtitle" id="navyDefenseSubtitle">القيمة الفعلية (بليون $)</p></div>
        <div class="chart-container"><canvas id="navyDefenseGrowthChartCanvas" class="chart-canvas"></canvas></div>
      </div>
    </section>
  </div>

  <footer>
    <p>© 2025 قوانين العصر الحديث العربي. جميع الحقوق محفوظة.</p>
  </footer>

  <div class="loader-container" id="loader">
    <div class="loader"></div>
  </div>

  <div id="chartModal" class="modal">
    <div class="modal-content">
      <div class="modal-header">
        <h2 id="modalChartTitle" class="modal-title"></h2>
        <button class="close-btn" onclick="closeModal()">×</button>
      </div>
      <div class="modal-chart-container">
        <canvas id="modalChartCanvas" class="modal-chart-canvas"></canvas>
      </div>
    </div>
  </div>

  <script>
    // ===================== Global Variables =====================
    let allData = { seasons: [], sessions: [] };
    let yearlyData = new Map();
    let selectedSeason = null;
    let selectedSession1 = null;
    let selectedSession2 = null;
    let currentCharts = {};
    let chartDataCache = {};
    let currentViewType = 'value';
    const API_URL = 'stats.php'; 

    const dom = {
        loader: document.getElementById('loader'),
        seasonSelector: document.getElementById('seasonSelector'),
        session1Selector: document.getElementById('session1Selector'),
        session2Selector: document.getElementById('session2Selector'),
        viewTypeSelector: document.getElementById('viewType'),
        compareButton: document.getElementById('compareButton'),
        chartsGrid: document.getElementById('chartsGrid')
    };

    const countryNameMapping = { "AFG": "Afghanistan", "ARM": "Armenia", "BFA": "Burkina Faso", "BLR": "Belarus", "GER": "Germany", "EST": "Estonia", "FIN": "Finland", "FRA": "France", "ITA": "Italy", "HOL": "Netherlands", "NOR": "Norway", "POL": "Poland", "ROM": "Romania", "SOV": "Russia", "SPR": "Spain", "SWE": "Sweden", "UKR": "Ukraine", "ENG": "United Kingdom", "SER": "Yugoslavia", "CHI": "China", "RAJ": "India", "IND": "Indonesia", "JAP": "Japan", "BRM": "Myanmar", "NEP": "Nepal", "NKO": "North Korea", "PAK": "Pakistan", "KOR": "South Korea", "TAL": "Taliban", "SIA": "Thailand", "BRA": "Brazil", "CAN": "Canada", "COL": "Colombia", "CUB": "Cuba", "MEX": "Mexico", "NIC": "Nicaragua", "USA": "United States", "DRC": "Congo DR", "CDI": "Ivory Coast", "EGY": "Egypt", "LBA": "Libya", "MOR": "Morocco", "NIG": "Nigeria", "SAF": "South Africa", "SUD": "Sudan", "PER": "Iran", "IRQ": "Iraq", "ISR": "Israel", "SAU": "Saudi Arabia", "SYR": "Syria", "TUR": "Turkey", "UAE": "UAE", "YEM": "Yemen", "AST": "Australia", "VEN": "Venezuela", "UZB": "Uzbekistan", "KAZ": "Kazakhstan", "AZE": "Azerbaijan", "ARG": "Argentina", "VIE": "Vietnam", "ALG": "Algeria", "SIN": "Singapore", "SOM": "Somalia", "SLO": "Czechoslovakia", "MAY": "Malaysia", "ETH": "Ethiopia", "HUN": "Hungary", "HEZ": "Hezbollah", "WAG": "Wagner", "TWN": "Taiwan", "LBN": "Lebanon", "JOR": "Jordan", "TUN": "Tunisia", "KEN": "Kenya", "ARE": "United Arab Emirates", "GAZ": "Gaza Strip", "SRB": "Serbia", "CZE": "Czech Republic", "BEL": "Belgium", "GRC": "Greece", "PRT": "Portugal", "COG": "Democratic Republic of the Congo", "D02": "Yemen" };

    // ===================== Initialization & Data Fetching =====================
    
    document.addEventListener('DOMContentLoaded', async () => {
        setupEventListeners();
        toggleSessionSelectors(); // <-- JAVASCRIPT CHANGE: Hide S2 on load
        await fetchInitialData();
        hideLoader();
    });

    async function fetchInitialData() {
        showLoader("جاري تحميل بيانات المواسم والجلسات...");
        try {
            const response = await fetch(`${API_URL}?action=getInitialData`);
            if (!response.ok) throw new Error(`HTTP error! status: ${response.status}`);
            const data = await response.json();
            if (!data.success) throw new Error(data.message);
            allData = { seasons: data.seasons, sessions: data.sessions };
            populateSeasonSelector();
        } catch (error) {
            console.error("Fetch error:", error);
            alert("فشل في جلب البيانات الأولية: " + error.message);
        } finally {
            hideLoader();
        }
    }

    async function loadSessionData(sessionId) {
        if (yearlyData.has(sessionId)) {
            return yearlyData.get(sessionId);
        }
        showLoader(`جاري تحميل بيانات الجلسة ${sessionId}...`);
        try {
            const response = await fetch(`${API_URL}?action=getStatsForSession&session_id=${sessionId}`);
            if (!response.ok) throw new Error(`Failed to load stats. Status: ${response.status}`);
            
            const jsonData = await response.json();
            const countryMap = new Map();

            if (Array.isArray(jsonData)) {
                jsonData.forEach(item => {
                    if (item.code) {
                        const mappedItem = {
                            ...item,
                            factories: {
                                civilian: item.factories_civilian,
                                military: item.factories_military,
                                naval: item.factories_naval
                            }
                        };
                        countryMap.set(item.code, mappedItem);
                    }
                });
            }
            yearlyData.set(sessionId, countryMap);
            return countryMap;
        } catch (error) {
            console.error("Error loading session data:", error);
            alert("فشل في تحميل بيانات الجلسة: " + error.message);
            return new Map();
        } finally {
            hideLoader();
        }
    }

    // ===================== UI & Event Handlers =====================

    function setupEventListeners() {
        dom.seasonSelector.addEventListener('change', handleSeasonChange);
        dom.session1Selector.addEventListener('change', () => {
            selectedSession1 = dom.session1Selector.value;
            validateControls();
        });
        dom.session2Selector.addEventListener('change', () => {
            selectedSession2 = dom.session2Selector.value;
            validateControls();
        });
        dom.viewTypeSelector.addEventListener('change', () => {
            currentViewType = dom.viewTypeSelector.value;
            toggleSessionSelectors();
            validateControls();
        });
        document.querySelectorAll('.chart-card').forEach(card => {
            card.addEventListener('click', function() {
                const chartId = this.querySelector('canvas').id;
                const chartTitle = this.querySelector('h3').textContent;
                openModal(chartId, chartTitle);
            });
        });
        document.getElementById('chartModal').addEventListener('click', function(e) {
            if (e.target === this) closeModal();
        });
    }

    function populateSeasonSelector() {
        dom.seasonSelector.innerHTML = '<option value="">اختر موسماً</option>';
        allData.seasons.forEach(season => {
            const option = new Option(season.season_name, season.season_id);
            dom.seasonSelector.appendChild(option);
        });
    }

    function handleSeasonChange() {
        selectedSeason = dom.seasonSelector.value;
        if (selectedSeason) {
            populateSessionSelectors(selectedSeason);
            dom.session1Selector.disabled = false;
            dom.session2Selector.disabled = false;
        } else {
            dom.session1Selector.innerHTML = '<option value="">اختر موسماً أولاً</option>';
            dom.session2Selector.innerHTML = '<option value="">اختر موسماً أولاً</option>';
            dom.session1Selector.disabled = true;
            dom.session2Selector.disabled = true;
        }
        selectedSession1 = null;
        selectedSession2 = null;
        validateControls();
    }

    function populateSessionSelectors(seasonId) {
        const relevantSessions = allData.sessions.filter(s => s.season_id == seasonId);
        dom.session1Selector.innerHTML = '<option value="">اختر الجلسة الأولى</option>';
        dom.session2Selector.innerHTML = '<option value="">اختر الجلسة الثانية (اختياري)</option>';
        relevantSessions.forEach(session => {
            const datePart = session.session_date ? session.session_date.split(' ')[0] : 'N/A';
            const optionText = `${session.session_name} (${datePart})`;
            dom.session1Selector.appendChild(new Option(optionText, session.session_id));
            dom.session2Selector.appendChild(new Option(optionText, session.session_id));
        });
    }

    function toggleSessionSelectors() {
        const session2Group = dom.session2Selector.parentElement;
        if (currentViewType === 'value') {
            session2Group.style.display = 'none';
        } else {
            session2Group.style.display = 'block';
        }
    }
    
    function validateControls() {
        let valid = true;
        if (!selectedSession1) valid = false;
        if (currentViewType !== 'value' && !selectedSession2) valid = false;
        if (currentViewType !== 'value' && selectedSession1 === selectedSession2) valid = false;
        dom.compareButton.disabled = !valid;
    }

    async function compareSessions() {
        if (dom.compareButton.disabled) {
            alert("يرجى التأكد من اختياراتك. للمقارنة (الفرق أو النسبة) يجب اختيار جلستين مختلفتين.");
            return;
        }
        currentViewType = dom.viewTypeSelector.value;
        updateSubtitles();
        showLoader("جاري مقارنة الجلسات...");
        try {
            const dataS1 = await loadSessionData(selectedSession1);
            let dataS2 = new Map();
            if (currentViewType !== 'value' && selectedSession2) {
                dataS2 = await loadSessionData(selectedSession2);
            }
            if (!dataS1) { alert("البيانات للجلسة المحددة غير موجودة."); return; }
            destroyAllCharts();
            dom.chartsGrid.querySelectorAll('.chart-card').forEach(card => card.style.opacity = 0);
            renderChart('gdpGrowthChartCanvas', 'gdp_total', 'الناتج المحلي الإجمالي', dataS1, dataS2);
            renderChart('civilianFactoriesGrowthChartCanvas', 'factories.civilian', 'المصانع المدنية', dataS1, dataS2);
            renderChart('militaryFactoriesGrowthChartCanvas', 'factories.military', 'المصانع العسكرية', dataS1, dataS2);
            renderChart('navalFactoriesGrowthChartCanvas', 'factories.naval', 'المصانع البحرية', dataS1, dataS2);
            renderChart('totalDefenseGrowthChartCanvas', 'defence_gain', 'إجمالي الإنفاق الدفاعي', dataS1, dataS2);
            renderChart('debtGrowthChartCanvas', 'debt', 'الدين', dataS1, dataS2);
            renderChart('gdpPerCapitaGrowthChartCanvas', 'gdp_per_capita', 'الناتج المحلي الإجمالي للفرد', dataS1, dataS2);
            renderChart('overallProductivityGrowthChartCanvas', 'overall_productivity', 'الإنتاجية الكلية', dataS1, dataS2);
            renderChart('landDefenseGrowthChartCanvas', 'defence_breakdown_land', 'تكاليف القوات البرية', dataS1, dataS2);
            renderChart('airDefenseGrowthChartCanvas', 'defence_breakdown_airforce', 'تكاليف القوات الجوية', dataS1, dataS2);
            renderChart('navyDefenseGrowthChartCanvas', 'defence_breakdown_navy', 'تكاليف القوات البحرية', dataS1, dataS2);
        } catch (error) {
            console.error("Error during comparison:", error);
            alert("حدث خطأ: " + error.message);
        } finally {
            hideLoader();
        }
    }

    function showLoader(message = "") { dom.loader.classList.remove('hidden'); }
    function hideLoader() { dom.loader.classList.add('hidden'); }

    // ===================== Utility Functions (Identical) =====================
    function formatNumberForChart(value) { if (value === "N/A" || value === null || value === undefined) return 0; const num = parseFloat(value); return isNaN(num) ? 0 : num; }
    function getValue(obj, key) { try { const parts = key.split('.'); let current = obj; for (let i = 0; i < parts.length; i++) { if (current === null || current === undefined) return 'N/A'; current = current[parts[i]]; } return current !== undefined ? current : 'N/A'; } catch (e) { return 'N/A'; } }
    function calculatePercentageChange(value1, value2) { const numVal1 = formatNumberForChart(value1); const numVal2 = formatNumberForChart(value2); if (numVal1 <= 0 && numVal2 <= 0) return 0; if (numVal1 === 0 && numVal2 === 0) return 0; if (numVal1 === 0 && numVal2 > 0) return 1000; if (numVal1 > 0 && numVal2 === 0) return -100; const change = ((numVal2 - numVal1) / numVal1) * 100; return Math.max(-1000, Math.min(1000, change)); }
    function calculateDifference(value1, value2) { const numVal1 = formatNumberForChart(value1); const numVal2 = formatNumberForChart(value2); return numVal2 - numVal1; }
    function openModal(chartId, chartTitle) { const modal = document.getElementById('chartModal'); const modalTitle = document.getElementById('modalChartTitle'); const modalCanvas = document.getElementById('modalChartCanvas'); modalTitle.textContent = chartTitle; const chartData = chartDataCache[chartId]; if (!chartData) return; if (currentCharts['modalChart']) { currentCharts['modalChart'].destroy(); } const ctx = modalCanvas.getContext('2d'); currentCharts['modalChart'] = createChartInstance(ctx, chartData.labels, chartData.dataPoints, [], [], chartTitle, true); modal.style.display = 'block'; document.body.style.overflow = 'hidden'; }
    function closeModal() { const modal = document.getElementById('chartModal'); modal.style.display = 'none'; document.body.style.overflow = 'auto'; }
    function createChartInstance(ctx, labels, dataPoints, backgroundColors, borderColors, chartTitle, isModal = false) { let finalBackgroundColors = []; let finalBorderColors = []; if (currentViewType === 'value') { finalBackgroundColors = dataPoints.map(() => 'rgba(59, 130, 246, 0.7)'); finalBorderColors = dataPoints.map(() => 'rgba(59, 130, 246, 1)'); } else { finalBackgroundColors = dataPoints.map(value => (value > 0) ? 'rgba(34, 197, 94, 0.7)' : (value < 0) ? 'rgba(239, 68, 68, 0.7)' : 'rgba(148, 163, 184, 0.7)'); finalBorderColors = dataPoints.map(value => (value > 0) ? 'rgba(34, 197, 94, 1)' : (value < 0) ? 'rgba(239, 68, 68, 1)' : 'rgba(148, 163, 184, 1)'); } let minY = Math.min(...dataPoints); let maxY = Math.max(...dataPoints); if (currentViewType === 'percentage') { minY = Math.max(-100, Math.min(minY, -10)); maxY = Math.min(1000, Math.max(maxY, 10)); } else if (currentViewType === 'difference') { const p = (maxY - minY) * 0.1; minY -= p; maxY += p; } else { minY = Math.min(0, minY); } let yAxisTitle = '', tooltipSuffix = ''; if (currentViewType === 'percentage') { yAxisTitle = 'النسبة المئوية (%)'; tooltipSuffix = '%'; } else if (currentViewType === 'difference') { yAxisTitle = 'الفرق'; if (chartTitle.includes('الناتج') || chartTitle.includes('الإنفاق') || chartTitle.includes('الدين')) tooltipSuffix = ' بليون $'; } else { yAxisTitle = 'القيمة'; if (chartTitle.includes('الناتج') || chartTitle.includes('الإنفاق') || chartTitle.includes('الدين')) tooltipSuffix = ' بليون $'; } return new Chart(ctx, { type: 'bar', data: { labels: labels, datasets: [{ label: chartTitle, data: dataPoints, backgroundColor: finalBackgroundColors, borderColor: finalBorderColors, borderWidth: 1, borderRadius: 4 }] }, options: { responsive: true, maintainAspectRatio: false, scales: { y: { beginAtZero: currentViewType === 'value', min: currentViewType !== 'value' ? minY : undefined, max: currentViewType !== 'value' ? maxY : undefined, title: { display: true, text: yAxisTitle, color: '#f5f5f5', font: { size: 14, weight: 'bold', family: 'Tajawal, sans-serif' }}, ticks: { color: '#e5e5e5', font: { size: 12, family: 'Tajawal, sans-serif' }, callback: function(value) { if (currentViewType === 'percentage') return value + '%'; if (chartTitle.includes('الناتج') || chartTitle.includes('الإنفاق') || chartTitle.includes('الدين')) return value.toLocaleString() + ' بليون $'; return value.toLocaleString(); } }, grid: { color: 'rgba(255, 255, 255, 0.1)', borderColor: 'rgba(255, 255, 255, 0.2)' } }, x: { ticks: { color: '#e5e5e5', font: { size: isModal ? 12 : 10, family: 'Tajawal, sans-serif' } }, grid: { display: false } } }, plugins: { legend: { display: false }, tooltip: { backgroundColor: 'rgba(0, 0, 0, 0.8)', titleColor: '#ffffff', bodyColor: '#ffffff', borderColor: 'rgba(255, 255, 255, 0.2)', borderWidth: 1, cornerRadius: 8, bodyFont: { size: 14, family: 'Tajawal, sans-serif' }, titleFont: { size: 16, family: 'Tajawal, sans-serif', weight: 'bold' }, padding: 12, callbacks: { label: function(context) { let value = context.parsed.y; let formattedValue = value.toLocaleString(); if (currentViewType === 'percentage') { formattedValue = value.toFixed(1) + '%'; } else { formattedValue += tooltipSuffix; } return chartTitle + ': ' + formattedValue; } } } }, animation: { duration: 800, easing: 'easeInOutQuart' } } }); }
    function destroyAllCharts() { for (const chartId in currentCharts) { if (currentCharts[chartId]) { currentCharts[chartId].destroy(); currentCharts[chartId] = null; } } }
    function renderChart(canvasId, metricKey, chartTitle, dataS1, dataS2) { const ctx = document.getElementById(canvasId)?.getContext('2d'); if (!ctx) return; if (currentCharts[canvasId]) { currentCharts[canvasId].destroy(); } const allCountryCodes = new Set([...dataS1.keys()]); const chartData = []; allCountryCodes.forEach(countryCode => { const displayName = countryNameMapping[countryCode] || countryCode; const val1 = getValue(dataS1.get(countryCode), metricKey); let val2 = 'N/A'; if (currentViewType !== 'value' && dataS2.has(countryCode)) { val2 = getValue(dataS2.get(countryCode), metricKey); } let displayValue; if (currentViewType === 'percentage') { displayValue = calculatePercentageChange(val1, val2); } else if (currentViewType === 'difference') { displayValue = calculateDifference(val1, val2); } else { displayValue = formatNumberForChart(val1); } chartData.push({ name: displayName, value: displayValue, countryCode: countryCode }); }); chartData.sort((a, b) => b.value - a.value); let mainChartData = []; if (currentViewType === 'value') { mainChartData = chartData.slice(0, 15); } else { const topPositive = chartData.filter(item => item.value > 0).slice(0, 8); const topNegative = chartData.filter(item => item.value < 0).slice(0, 8); mainChartData = [...topPositive, ...topNegative].sort((a, b) => b.value - a.value); } const labels = mainChartData.map(item => item.name); const dataPoints = mainChartData.map(item => item.value); chartDataCache[canvasId] = { labels: chartData.map(item => item.name), dataPoints: chartData.map(item => item.value), title: chartTitle }; currentCharts[canvasId] = createChartInstance(ctx, labels, dataPoints, [], [], chartTitle, false); }
    function updateSubtitles() { const viewType = document.getElementById('viewType').value; let subtitleText = ''; if (viewType === 'percentage') subtitleText = 'النسبة المئوية للتغيير'; else if (viewType === 'difference') subtitleText = 'الفرق بين الجلستين'; else subtitleText = 'القيمة الفعلية'; document.getElementById('gdpSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (بليون $)' : ''); document.getElementById('civilianSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (العدد الفعلي)' : ''); document.getElementById('militarySubtitle').textContent = subtitleText + (viewType === 'value' ? ' (العدد الفعلي)' : ''); document.getElementById('navalSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (العدد الفعلي)' : ''); document.getElementById('defenseSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (بليون $)' : ''); document.getElementById('debtSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (بليون $)' : ''); document.getElementById('gdpCapitaSubtitle').textContent = subtitleText + (viewType === 'value' ? ' ($)' : ''); document.getElementById('productivitySubtitle').textContent = subtitleText + (viewType === 'value' ? ' (القيمة الفعلية)' : ''); document.getElementById('landDefenseSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (بليون $)' : ''); document.getElementById('airDefenseSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (بليون $)' : ''); document.getElementById('navyDefenseSubtitle').textContent = subtitleText + (viewType === 'value' ? ' (بليون $)' : ''); }
  </script>
</body>
</html>