<?php
// Database Configuration
$host = 'localhost';
$dbname = 'shafpknj_arabstrg'; // --- Using the v4 DB
$username = 'shafpknj_ahmed';
$password = '2719243214kK';

// Set header to JSON
header('Content-Type: application/json');

// JSON output helper
function json_response($success, $message, $data = []) {
    die(json_encode(['success' => $success, 'message' => $message, 'data' => $data], JSON_UNESCAPED_UNICODE));
}

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    json_response(false, "Connection failed: " . $e->getMessage());
}

session_start();

// Determine action from POST or GET
$action = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // POST for write actions (admin)
    if (!empty($_POST['action'])) {
        $action = $_POST['action']; // From form-data (e.g., file upload)
    } else {
        // Fallback for raw JSON post
        $json_input = file_get_contents('php://input');
        $data = json_decode($json_input, true);
        if (isset($data['action'])) {
            $action = $data['action'];
        }
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // GET for read actions (public)
    if (isset($_GET['action'])) {
        $action = $_GET['action'];
    }
}


// --- Admin Auth Check Function ---
function check_admin_auth($pdo) {
    if (!isset($_SESSION['user_id'])) return false;
    
    $stmt = $pdo->prepare("SELECT user_rank FROM users WHERE user_id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user && $user['user_rank'] == 5) {
        return true;
    }
    return false;
}
// --- End Admin Auth Check ---


switch ($action) {
    
    // --- ADMIN ACTION (Write) ---
    // Used by admin_stats_importer.php
    case 'import_json':
        if (!check_admin_auth($pdo)) {
            json_response(false, 'Access Denied: Administrator privileges required.');
        }

        try {
            if (!isset($_FILES['json_file']) || $_FILES['json_file']['error'] !== UPLOAD_ERR_OK) {
                throw new Exception('خطأ في رفع الملف. تأكد من اختيار ملف.');
            }
            if (!isset($_POST['session_id']) || empty($_POST['session_id'])) {
                throw new Exception('لم يتم تحديد الجلسة.');
            }

            $session_id = (int)$_POST['session_id'];
            $json_content = file_get_contents($_FILES['json_file']['tmp_name']);
            $stats_data = json_decode($json_content, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception('ملف JSON غير صالح. ' . json_last_error_msg());
            }

            // Prepare the INSERT... ON DUPLICATE KEY UPDATE query
            $sql = "INSERT INTO session_country_stats (
                        session_id, country_tag, country_name, factories_civilian, factories_military, factories_naval,
                        gdp_total, gdp_per_capita, overall_productivity, defence_breakdown_airforce,
                        defence_breakdown_industry, defence_breakdown_industry_gdp_modifier,
                        defence_breakdown_land, defence_breakdown_navy, defence_gain, debt, imp_refugees_taken_k
                    ) VALUES (
                        :session_id, :country_tag, :country_name, :factories_civilian, :factories_military, :factories_naval,
                        :gdp_total, :gdp_per_capita, :overall_productivity, :defence_breakdown_airforce,
                        :defence_breakdown_industry, :defence_breakdown_industry_gdp_modifier,
                        :defence_breakdown_land, :defence_breakdown_navy, :defence_gain, :debt, :imp_refugees_taken_k
                    )
                    ON DUPLICATE KEY UPDATE
                        country_name = VALUES(country_name),
                        factories_civilian = VALUES(factories_civilian),
                        factories_military = VALUES(factories_military),
                        factories_naval = VALUES(factories_naval),
                        gdp_total = VALUES(gdp_total),
                        gdp_per_capita = VALUES(gdp_per_capita),
                        overall_productivity = VALUES(overall_productivity),
                        defence_breakdown_airforce = VALUES(defence_breakdown_airforce),
                        defence_breakdown_industry = VALUES(defence_breakdown_industry),
                        defence_breakdown_industry_gdp_modifier = VALUES(defence_breakdown_industry_gdp_modifier),
                        defence_breakdown_land = VALUES(defence_breakdown_land),
                        defence_breakdown_navy = VALUES(defence_breakdown_navy),
                        defence_gain = VALUES(defence_gain),
                        debt = VALUES(debt),
                        imp_refugees_taken_k = VALUES(imp_refugees_taken_k)";
            
            $stmt = $pdo->prepare($sql);
            
            $pdo->beginTransaction();
            $processed_count = 0;
            // The JSON from your tool is an array of objects
            foreach ($stats_data as $country_stat) {
                // Helper function to safely get nested values
                $get = fn($arr, $key, $default = null) => array_reduce(explode('.', $key), fn($a, $b) => $a[$b] ?? $default, $arr);
                
                // Use 'code' from your JSON structure
                $country_tag = $get($country_stat, 'code', 'N/A');
                if ($country_tag === 'N/A') continue; // Skip if no tag

                $stmt->execute([
                    'session_id' => $session_id,
                    'country_tag' => $country_tag,
                    'country_name' => $get($country_stat, 'name', 'N/A'),
                    'factories_civilian' => $get($country_stat, 'factories.civilian', 0),
                    'factories_military' => $get($country_stat, 'factories.military', 0),
                    'factories_naval' => $get($country_stat, 'factories.naval', 0),
                    'gdp_total' => $get($country_stat, 'gdp_total', 0),
                    'gdp_per_capita' => $get($country_stat, 'gdp_per_capita', 0),
                    'overall_productivity' => $get($country_stat, 'overall_productivity', 0),
                    'defence_breakdown_airforce' => $get($country_stat, 'defence_breakdown_airforce', 0),
                    'defence_breakdown_industry' => $get($country_stat, 'defence_breakdown_industry', 0),
                    'defence_breakdown_industry_gdp_modifier' => (string)$get($country_stat, 'defence_breakdown_industry_gdp_modifier', 0),
                    'defence_breakdown_land' => $get($country_stat, 'defence_breakdown_land', 0),
                    'defence_breakdown_navy' => $get($country_stat, 'defence_breakdown_navy', 0),
                    'defence_gain' => $get($country_stat, 'defence_gain', 0),
                    'debt' => $get($country_stat, 'debt', 0),
                    'imp_refugees_taken_k' => $get($country_stat, 'imp_refugees_taken_k', 0)
                ]);
                $processed_count++;
            }
            $pdo->commit();
            
            json_response(true, "تمت معالجة $processed_count سجل بنجاح للجلسة $session_id.");

        } catch (Exception $e) {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
            json_response(false, 'خطأ: ' . $e->getMessage());
        }
        break;

    // --- PUBLIC ACTION (Read) ---
    // Used by stats_test_page.php
    case 'getSessions':
        try {
            // Fetch ALL sessions that have at least one stat entry
            // This ensures we only show sessions that have data
            $stmt = $pdo->query("
                SELECT s.session_id, s.session_name, s.session_date
                FROM sessions s
                WHERE EXISTS (
                    SELECT 1 FROM session_country_stats scs 
                    WHERE scs.session_id = s.session_id
                )
                ORDER BY s.session_date ASC
            ");
            $sessions = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Return the sessions array directly
            die(json_encode($sessions, JSON_UNESCAPED_UNICODE));
            
        } catch (PDOException $e) {
            json_response(false, $e->getMessage());
        }
        break;

    // --- PUBLIC ACTION (Read) ---
    // Used by stats_test_page.php
    case 'getStatsForSession':
        try {
            $session_id = $_GET['session_id'] ?? null;
            if (!$session_id) {
                throw new Exception('لم يتم تحديد الجلسة.');
            }
            
            // Fetch stats directly from the database
            $stmt = $pdo->prepare("SELECT * FROM session_country_stats WHERE session_id = ?");
            $stmt->execute([$session_id]);
            $stats = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Re-format data to match the JSON structure stats.php expects
            $output_data = [];
            foreach ($stats as $row) {
                $output_data[] = [
                    'code' => $row['country_tag'],
                    'name' => $row['country_name'],
                    'cosmeticTag' => $row['country_tag'],
                    'factories' => [
                        'civilian' => $row['factories_civilian'],
                        'military' => $row['factories_military'],
                        'naval' => $row['factories_naval']
                    ],
                    'gdp_total' => (float)$row['gdp_total'],
                    'gdp_per_capita' => (float)$row['gdp_per_capita'],
                    'overall_productivity' => (int)$row['overall_productivity'],
                    'defence_breakdown_airforce' => (float)$row['defence_breakdown_airforce'],
                    'defence_breakdown_industry' => (float)$row['defence_breakdown_industry'],
                    'defence_breakdown_industry_gdp_modifier' => $row['defence_breakdown_industry_gdp_modifier'],
                    'defence_breakdown_land' => (float)$row['defence_breakdown_land'],
                    'defence_breakdown_navy' => (float)$row['defence_breakdown_navy'],
                    'defence_gain' => (float)$row['defence_gain'],
                    'debt' => (float)$row['debt'],
                    'imp_refugees_taken_k' => (float)$row['imp_refugees_taken_k']
                ];
            }
            
            // Return the data as a JSON array
            die(json_encode($output_data, JSON_UNESCAPED_UNICODE));

        } catch (Exception $e) {
            json_response(false, $e->getMessage());
        }
        break;

    default:
        json_response(false, 'Invalid action specified.');
}
?>